/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.windows.SpaceStationWindow;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipe;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipesManager;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector4i;

public class SpaceStationList
extends AbstractScrollWidget {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"icon/scroller");
    public Map<Vector4i, SpaceStationRecipesManager.SpaceStationRecipeState> spaceStationRecipeStateMap = new HashMap<Vector4i, SpaceStationRecipesManager.SpaceStationRecipeState>();
    private final AtomicInteger finalHeight = new AtomicInteger(0);
    private final SpaceStationWindow window;
    public ArrayList<SpaceStationRecipesManager.SpaceStationRecipeState> spaceStationRecipeStates;

    public SpaceStationList(int x, int y, int width, int height, Component message, SpaceStationWindow window) {
        super(x, y, width, height, message);
        this.window = window;
        this.spaceStationRecipeStates = SpaceStationList.getSpaceStationRecipeStates();
    }

    protected int getInnerHeight() {
        return this.finalHeight.get();
    }

    protected void renderBorder(GuiGraphics guiGraphics, int x, int y, int width, int height) {
    }

    protected double scrollRate() {
        return 9.0;
    }

    protected void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.finalHeight.set(0);
        for (int i = 0; i < this.spaceStationRecipeStates.size(); ++i) {
            int x = this.window.getWindowX() + 40;
            int y = i * 35;
            SpaceStationRecipesManager.SpaceStationRecipeState recipeState = this.spaceStationRecipeStates.get(i);
            SpaceStationButton launchPadWidget = new SpaceStationButton(recipeState, x, this.getY() + y, this.width + 19, this);
            launchPadWidget.render(guiGraphics, mouseX, (int)((double)mouseY + this.scrollAmount()), partialTick);
            this.spaceStationRecipeStateMap.putIfAbsent(launchPadWidget.buttonPositions, recipeState);
            this.finalHeight.addAndGet(y);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void renderScrollBar(GuiGraphics guiGraphics) {
        int i = this.getScrollBarHeight();
        int j = this.getX() + this.width;
        int k = Math.max(this.getY(), (int)this.scrollAmount() * (this.height - i) / this.getMaxScrollAmount() + this.getY());
        RenderSystem.enableBlend();
        guiGraphics.blitSprite(SCROLLER_SPRITE, j, k, 8, i);
        RenderSystem.disableBlend();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.spaceStationRecipeStateMap != null) {
            for (Map.Entry<Vector4i, SpaceStationRecipesManager.SpaceStationRecipeState> entry : this.spaceStationRecipeStateMap.entrySet()) {
                Vector4i pos = entry.getKey();
                SpaceStationRecipesManager.SpaceStationRecipeState state = entry.getValue();
                if (!Utils.isHoveredOnSprite(pos.x, (int)((double)pos.y - this.scrollAmount()), pos.z, pos.w, (int)mouseX, (int)mouseY)) continue;
                if (state.isUnlocked() || this.window.parent.getPlayer().isCreative()) {
                    this.window.spaceStationSelected = state;
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public Font getFont() {
        return Minecraft.getInstance().font;
    }

    public static ArrayList<SpaceStationRecipesManager.SpaceStationRecipeState> getSpaceStationRecipeStates() {
        ArrayList<SpaceStationRecipesManager.SpaceStationRecipeState> states = new ArrayList<SpaceStationRecipesManager.SpaceStationRecipeState>();
        if (Minecraft.getInstance().player == null) {
            return states;
        }
        for (SpaceStationRecipe recipe : SpaceStationRecipesManager.SPACE_STATION_RECIPES) {
            states.add(recipe.fromRecipe((Player)Minecraft.getInstance().player));
        }
        return states;
    }

    public static class SpaceStationButton {
        public final SpaceStationRecipesManager.SpaceStationRecipeState recipeState;
        public final int x;
        public final int y;
        public final int width;
        public final SpaceStationList list;
        public Vector4i buttonPositions = new Vector4i();

        public SpaceStationButton(SpaceStationRecipesManager.SpaceStationRecipeState recipeState, int x, int y, int width, SpaceStationList list) {
            this.x = x;
            this.y = y;
            this.recipeState = recipeState;
            this.list = list;
            this.width = width;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.blitSprite(GUISprites.WINDOW_BAR, this.x + 20, this.y, this.width - 20, 30);
            guiGraphics.drawString(this.getFont(), (Component)this.recipeState.recipe().getDisplayName(), this.x + 27, this.y + 10, Utils.getColorHexCode("white"));
            TexturedButton selectButton = new TexturedButton(this.x + this.width - 54, this.y + 6, 49, 18, (Component)Component.literal((String)"Select"), btn -> {
                if (this.recipeState.isUnlocked()) {
                    this.list.window.spaceStationSelected = this.recipeState;
                }
            });
            selectButton.setTooltip(Tooltip.create((Component)this.recipeState.recipe().getTooltip(this.list.window.parent.getPlayer())));
            this.buttonPositions = new Vector4i(selectButton.getX(), selectButton.getY(), selectButton.getWidth(), selectButton.getHeight());
            if (this.recipeState.isUnlocked() || this.list.window.parent.getPlayer().isCreative()) {
                selectButton.tex(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/select_button.png"), ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/select_button_hovered.png"));
            } else {
                selectButton.tex(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/select_button.png"), ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/select_button.png"));
            }
            selectButton.render(guiGraphics, mouseX, mouseY, partialTick);
            if (Utils.isHoveredOnSprite(this.x, this.y, this.list.window.getWidth() - 80, 30, mouseX, mouseY) && this.list.isHovered()) {
                guiGraphics.renderTooltip(this.getFont(), selectButton.getTooltip().toCharSequence(Minecraft.getInstance()), mouseX, mouseY);
            }
        }

        public Font getFont() {
            return Minecraft.getInstance().font;
        }
    }
}

